*use ~/research/BPEA_recession/data/Stabu/kug

/* need to massage the data on Kurzarbeitergeld payments; various issues:
   - yearly, so make quarterly using hours ausgefallen
   - some in DM some in Euros
   - nominal
   - missing 2004/5/6, guess using hours ausgefallen
     HAVE FOUND FILES ONLINE AT BA CAN USE VALUES INSTEAD
   - for 1974 only have including ABM, adjust using 1973/5 ratios 
   - how to deal with break in 1991: subtract from Lohnkosten before deal
     with break in Lohnkosten, then adjust Lohnkosten as before 
     (ie same method as before, not necessarily same ratio)

   - also, 2007-9 numbers in Stat Jahrbuch are only konjunkturelle KA
     whereas in files now found have all, so change these too
   - note: 2010 file can't quite do this
   here deal with DM and missing values
*/

* DM into Euros
gen kug_u_n_y=kug_E_u_n
replace kug_u_n_y=kug_DM_u_n/1.95583 if kug_u_n_y==.
label var kug_u_n_y "Kurzarbeit spending nom Euros Germany yrly"
gen kug_w_n_y=kug_DM_w_n/1.95583
label var kug_w_n_y "Kurzarbeit spending nom Euros West yrly"
gen kug_e_n_y=kug_DM_e_n/1.95583
label var kug_e_n_y "Kurzarbeit spending nom Euros East yrly"

drop *DM* *E*

* impute 1974 where have only Kug+ABM
* 1973 Kug=74, Kug+ABM=94, Kug=78.7%; 1975 Kug=2207, Kug+ABM=2334, Kug=94.6%
* take average = 86.6%; so Kug=.866*710=614.86=615
replace kug_w_n_y=615 if year==1974

* 2004-2006 from online BA files
replace kug_u_n_y=674 if year==2004
replace kug_u_n_y=635 if year==2005
replace kug_u_n_y=349 if year==2006

* more complete 2007-9 numbers from online BA files (incl non-konj KA)
replace kug_u_n_y=350 if year==2007
replace kug_u_n_y=433 if year==2008
replace kug_u_n_y=5173 if year==2009

/* impute 2010 from Nov 2010 file Michael's RA obtained, which has
  2010 to date, Nov 2010, and 2009; 2009 almost matches what had 
  (a bit smaller after sum the KA Geld and KA SS rebate numbers),
  so call Jan-Oct the 2010 year (since so far this year has only 3 quarters) */
replace kug_u_n_y=(1614351+1326718-60465-49165)/1000 if year==2010


/* assuming merged into other data using macro_q, now have quarterly info
  on the hours lost to KA, use to make the payments quarterly
  for the hours lost, calculate each quarter's share in the year
  deal with seasonally unadjusted numbers - seas adjusting the KA hours
  didn't work well, and shouldn't be seasonal pattern anyway */
egen kahoursyear_u=sum(kurzarbeit_u),by(year)
egen kahoursyear_w=sum(kurzarbeit_w),by(year)
gen qkahoursfrac_u=kurzarbeit_u/kahoursyear_u
gen qkahoursfrac_w=kurzarbeit_w/kahoursyear_w

gen kug_u_n=qkahoursfrac_u*kug_u_n_y
gen kug_w_n=qkahoursfrac_w*kug_w_n_y
label var kug_u_n "Kurzarbeit spending nom Euros Germany quarterly"
label var kug_w_n "Kurzarbeit spending nom Euros west quarterly"
drop qkahoursfrac* kahoursyear* kurzarbeit*



